// Datei: Duo_Akku_mein_16.ino   20.11.2025 19:00 Uhr - aktuellste Version!
// mit interner Arduino Referenz von 1,1 Volt und geändertem Spannungsteiler.
// Umschaltbare Version 1,2 und 3,7 Volt! Weiter machen...
// Interrupt geht nur an Pin 2 und 3 !
// Ich benutze hier Pin 3 für den Taster
// Interrupt, serial.print und Ports setzen sind etwas zeitkritisch , evtl. delays einbauen  19.11.2024
// PWM Pins = 3,5,6,9,10,11
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// ARDUINO BATTERY CAPACITY TESTER
// Version-1.0
// by deba168,INDIA
// Dated : 04/09/2016
// https://www.instructables.com/DIY-Arduino-Battery-Capacity-Tester-V10-/
// U8glib Library: https://github.com/olikraus/u8glib/wiki/userreference#begin
// Überarbeitet von DL8LAB Feb 2021 , Nov 2024
// Bei 1,2 Volt Akkus: Entladeschlussspannung: 0,9 Volt
// Bei 3,7 Volt Akkus: Entladeschlussspannung: 3,3 Volt
// Entladestrom bei 1,2V und 5 Ohm: 116mA 
// Entladestrom bei 3,7V und 10 Ohm: 377mA 
// 
//
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

#include "U8glib.h"                               // Olli Kraus Library für OLED SSD1306 bzw. 
#define Bat_Pin A0                                // (A0)   Messeingang 0 Low_End, (MOSFET)
#define Res_Pin A1                                // (A1)   Messeingang 1 High_End, (Widerstand)
#define Taster_Pin 3                              // (3) mit Interrupt) Start-Taster (Eingang)
#define MOSFET_Pin 2                              // D2 Ausgangspin zur Steuerung des MOSFET
#define NiMH_Pin 5                                // ist High, wenn auf NiMH Akku (1.2 Volt) umgeschaltet ist.
#define LED_gruen 7                               // D7 Ausgangspin für die "Start-LED"
#define LED_rot 8                                 // D8 Ausgangspin für die "Entlade-LED"
#define Buzzer_Pin 9                              // D9 Ausgangspin für den Alarm Buzzer (noch nicht eingebaut)

#include <EEPROM.h>                               // EEPROM Routinen zum Speichern von Daten
U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NONE);       // I2C / TWI  Objektzuweisung u8g
float Capacity = 0.0;                             // Kapazität in mAh
float Res_Value = 5;                              // (10 oder 5 Ohm) Widerstandswert in Ohm
//float Vcc = 4.44;                               // (4.64) Spannung am Arduino 5 V Pin (mit Multimeter gemessen) Spannungsteiler 10k:10k
float Vcc = 5.26;                                 // (5.27)  VCC = VRef/10k*(10k+39k)  ; Spannungsteiler== 10k:39k , Bitte RefSpg am Nano ueberpruefen
float Curr_Amp = 0.0;                             // Strom in Ampere
float Curr_mA=0;                                  // Strom in mA
float Bat_Volt = 0.0;                             // Spannung am hohen Punkt des Widerstandes (Akku Spannung)
float Res_Volt = 0.0;                             // Spannung am niedrigeren Punkt des Widerstandes 
float Bat_High ;                                  // (4.3 | 1.5) Akku Höchstpannung,  Battery High Voltage    // ändern auf 1.4 Volt bei AA oder AAA Akkus
float Bat_Low ;                                   // (3.3 | 0.9) Entladeschlussspannung,                     // ändern auf 0.9 Volt bei AA oder AAA Akkus (NC=0.85V, NiMH_Pin=1.0V) 
float Bat_deep = 2.4;                             // (2.4 | 0.5) tief entladen oder kein Akku
unsigned long previousMillis = 0;                 // Previous time in ms
unsigned long millisPassed = 0;                   // Curr_Amp time in ms
unsigned long millisAnz;                          // Anzeigerythmus
float sample1=0;                                  // Messwert 1
float sample2=0;                                  // Messwert 2
int row = 0;                                      // Reihe im OLED Display
float SpWert1;                                    // gespeicherter Wert1         
float SpWert2;                                    // gespeicherter Wert2        
float SpWert3;                                    // gespeicherter Wert3        
boolean fertig=true;                              // Prüfung fertig, damit nicht gleich in den Entlademodus gesprungen wird
boolean BtnPressed=false;
int AkkuLeer=0;                                   // Verzögerung der Anzeige 
byte count=0;                                     // Zaehler fuer wechselnde Anzeige

//*********************************************************************************
//*******************************  Setup  *****************************************  
  void setup() {
   analogReference(INTERNAL);     // interne Referenz ( 1,1 Volt) 

// Pin mit Button an Interrupt binden,  digitalPinToInterrupt wandelt Pin-Nr des GPIO in die entsprechende Interrupt-ID um.
   attachInterrupt(digitalPinToInterrupt(Taster_Pin), On_interrupt, FALLING);                         

   pinMode(MOSFET_Pin, OUTPUT);                   // Ansteuerung für den MOSFET Transistor
   pinMode(Buzzer_Pin, OUTPUT);                   // Ansteuerung des Buzzer
   pinMode(LED_gruen,  OUTPUT);                   // Ansteuerung für grüne LED
   pinMode(LED_rot,    OUTPUT);                   // Ansteuerung für rote LED
   
   pinMode(Taster_Pin, INPUT);                    // Taster Pin
   digitalWrite(Taster_Pin,  HIGH);               // Pullup für Tastereingang 
   pinMode(NiMH_Pin, INPUT);                      // Akku Auswahl-Eingang
   digitalWrite(NiMH_Pin,  HIGH);                 // Pullup für Auswahleingangs-Pin, LiPo - NiMH  (Jumper)
   digitalWrite(MOSFET_Pin, LOW);                 // MOSFET ist während des Starts abgeschaltet
   
   digitalWrite(LED_gruen,  HIGH);                // grüne LED während des Einschaltens EIN
   digitalWrite(LED_rot,    LOW);                 // rote LED während des Einschaltens AUS
   
   //delay(300);
   Serial.begin(115200);
  // delay(300);
   Serial.print(F("\n\nSketch:   "));   Serial.println(__FILE__);                                                   //   Sketchnamen ausgeben
   Serial.print(F("geflasht am: "));   Serial.print(__DATE__);  Serial.print(F(" um "));   Serial.print(__TIME__); Serial.println(F(" Uhr  "));    // Datum und Sketchzeit ausgeben
   Serial.println("Arduino 1,2 / 3,7 Volt Akku-Tester V1.6");
   
 attachInterrupt(digitalPinToInterrupt(Taster_Pin),   // Pin mit Button an Interrupt binden.
                On_interrupt, FALLING);           // digitalPinToInterrupt wandelt Pin-Nr des GPIO in die entsprechende Interrupt-ID um.


   //fertig = true;                               // nach Entnahme eines geprüften Akkus wieder auf "nicht fertig" setzen
   //Serial.print("fertig= ");Serial.println (fertig);
   
  delay (10);
   // Hier die Spannungsauswahl je nach Schalterstellungtief entladen oder kein Akku
   if(digitalRead (NiMH_Pin) == HIGH){    // April 2025 geändert
     Bat_High = 1.5;                      // Akku Höchstpannung,  Battery High Voltage
     Bat_Low = 0.9;                       // Entladeschlussspannung
     Bat_deep = 0.5;                      // tief entladen oder kein Akku
     Res_Value = 5;                       // bei 1,2 V Akku 5 Ohm
     Serial.println(F("Akkuwahlschalter: High = 1,2 Volt"));
   }
   else
   {
     Bat_High = 4.3;                      // Akku Höchstpannung,  Battery High Voltage
     Bat_Low = 3.3;                       // Entladeschlussspannung
     Bat_deep = 2.4;                      // tief entladen oder kein Akku
     Res_Value = 10;                      // bei 3,7 V Akku 10 Ohm
     Serial.println(F("Akkuwahlschalter: Low=3,7 Volt"));
   }
   
   eep_les();            //  Daten aus EEProm lesen
 
 //*******************   OLED - Startmeldung   *****************************************************
u8g.firstPage();  
   do {
    u8g.setFont(u8g_font_fub11r);                 // Schriftart setzen
    u8g.setPrintPos(10,20);                       // setzte Position
    u8g.println("Akku-Tester");                   // Zeige Text
    u8g.setPrintPos(30,40);                       // setzte Position
    u8g.println("DL8LAB");                        // zeige Text
    u8g.setPrintPos(14,60);                       // setzte Position
    u8g.println("Version 1.6");                   // Version 30.04.2025
  } while( u8g.nextPage() );                      //
   delay (2000);                                  // (2000) Anzeigedauer der Startmeldung
 //******************************************************************

  u8g.firstPage();  
   do {
    u8g.setFont(u8g_font_fub11r);                 // Schriftart setzen
    u8g.setPrintPos(30,20);                       // setzte Position
    if(digitalRead (NiMH_Pin) == HIGH){            // April 2025 geändert
      u8g.println("1,2 Volt");   
      u8g.setPrintPos(20,40);                     // setzte Position
      u8g.println("NiMH-Akku");      
    }
   else
   {
     u8g.println("3,7 Volt"); 
      u8g.setPrintPos(20,40);                     // setzte Position
    u8g.println("LiPo Akku"); 
   }   
   
    u8g.setPrintPos(30,60);                       // setzte Position
    u8g.println("einlegen"); 
  } while( u8g.nextPage() );
   delay (2000);                                  // Anzeigedauer für gewählten Akku-Typ
 //*********************************************************************************
 
 //****** Historie auf TFT anzeigen ************************************************
    SpAnz();                                      // Historie anzeigen, auch wenn schon ein Akuu eingelegt ist
    delay (5000);                                 // Historie 5 Sekunden anzeigen 
     u8g.firstPage();  
 do {     
     u8g.setPrintPos(34,40);                      // setzte Position 34, 40
     u8g.println("Bereit");   
   } while( u8g.nextPage() );
     u8g.firstPage();  
     Serial.println(F("Das Gerät ist bereit, bitte Akku einlegen und Start drücken"));
     delay (1000);                                // "Bereit" 3 Sekunden anzeigen 

     
 }

//---------------------------------------------------------------------------------
//---------- Setup Ende -----------------------------------------------------------
//---------------------------------------------------------------------------------




  
  //*********************************************************************************
  //************          Haupt Programmschleife         ****************************
  //*********************************************************************************
  void loop() {
     count++;                                     // Anzeigezaeher für verschiedene Display Szenen erhoehen
     if (count>4) { count=0; }                    // Ruecksetzen bei 4
    
   
  Messen();                                       // Messvorgang aufrufen 

// Serial.print(F( "msPassed: "));Serial.println (millisPassed);        // ca. 500ms wird zu MAh aufaddiert 
// Serial.print(F( "Prev Millis: "));Serial.println (previousMillis);   // letzter Vergleich

 // Serial.print(F( "AkkuSpg: "));Serial.print (Bat_Volt);Serial.println( "V");
 //***************** Überprüfe die verschiedenen Zustände *************
  
  if ( Bat_Volt > Bat_High){                      // Spannung am hohen Punkt des Widerstandes (Akku Spannung) > höchste zulässige Akku-Spannung
   digitalWrite(MOSFET_Pin, LOW);                 // MOSFET ausschalten - keine Entladung 
   digitalWrite(LED_rot, LOW);                    // Entlade-LED aus  
   beep(200);                                     // kurzer Piep-Ton
   Serial.print(F( "Warnung zu hohe Akku-Spannung! "));
   Serial.print (Bat_Volt);Serial.println(F( "V"));    
   }
   
   else if(Bat_Volt < Bat_Low)    // Spg. am hohen Pkt d. Widerstandes (Akku Spg) < Entladeschluss-Spg. + mind 2 Sek vergangen
   { 
      digitalWrite(MOSFET_Pin, LOW);              // MOSFET ausschalten - keine Entladung 
      digitalWrite(LED_rot, LOW);                 // Entlade-LED aus  
      beep(200);                                  // kurzer Piep-Ton
   M_fertig();                                    // Messung ist fertig  UP Aufruf
      Serial.println(F( "Akku entladen oder nicht eingelegt!"));
      Serial.print( "Bat_Volt: "); Serial.print (Bat_Volt);Serial.println( "V");      
      Serial.print( " Bat_Low: "); Serial.print (Bat_Low); Serial.println( "V");
       delay(1000);                               // ######
      
  }
  // -------- Die Akku-Spg. ist noch normalen Bereich u. das "fertig" Flag nicht gesetzt------------
  else if(Bat_Volt > Bat_Low && Bat_Volt < Bat_High && fertig==false ) { 
     // digitalWrite(MOSFET_Pin, HIGH);   // Entladung einschalten MOSFET ON  // weiterhin Enladung 
     // digitalWrite(LED_rot, HIGH);      // Entlade-LED ein  
      //Messen();
      millisPassed = millis() - previousMillis;             // Entladezeit speichern
      Curr_Amp = (Bat_Volt+0.01 - Res_Volt) / Res_Value;     // Strom = Bat_Spg - Wid_Spg/Widerstand Ohm - tatsächlicher  Strom
      Curr_mA = Curr_Amp * 1000.0 ;                          // Umrechnung in mA
      Capacity = Capacity + Curr_mA * (millisPassed / 3600000.0); // Kapazität speichern, 1 Stunde = 3600000ms
      previousMillis = millis();                            // letzten Wert speichern 
      if (millisAnz+3000 < millis())
      {
    millisAnz= millis();                                  //  MERKER für Anzeigedauer zurücksetzen
      Serial.print("Spg. High-End "); Serial.print(Bat_Volt); Serial.print("V  ");
      Serial.print("  Spg. Low-End ");Serial.print(Res_Volt);Serial.print("V ");
      Serial.print(" Strom ");Serial.print((Bat_Volt+0.01-Res_Volt)/Res_Value*1000);Serial.print(" mA ");
      Serial.print(" Kapazität ");Serial.print(Capacity);Serial.print(" mAh ");
      if((millis()/1000>59) && (millis()/1000 <3600)){
      // Serial.print(" Zeit ");Serial.print(millisAnz/1000/60);Serial.print(" Min ");
      Serial.print(" Zeit ");Serial.print(millis()/1000/60);Serial.print(" Min ");
      }
      if(millis()/1000>3599){
      // Serial.print(" Zeit ");Serial.print(millisAnz/1000/60);Serial.print(" Min ");
      Serial.print(" Zeit ");Serial.print(millis()/1000);Serial.print(" Std ");
      }
      else
       if(millis()/1000 <60)
      {
       
      Serial.print(" Zeit ");Serial.print(millis()/1000);Serial.print(" Sek ");
      }
      Serial.print(" fertig = ");Serial.println (fertig);  
      }
      row++;                                     //      
     
      //### delay(1000);                               //  (4000) ms Verzögerung (Anzeigezyklus)
     }
    
 
 //********  TFT Anzeigen  ****  (direkt anzeigen?) *********************************
  u8g.firstPage();  
  do {
    draw();                                       // OLED Anzeigeroutine aufrufen
  } while( u8g.nextPage() ); 
//********  TFT Anzeigen  Ende  *****************************************************



   if (AkkuLeer==0){ A_entladen(); delay (3000);}  // Der Akku ist entalden
 }    
// ----- Ende Loop   ---------------------------



// ---- Interrupt Service Routine ---------------------------------------------------------------------------------
void On_interrupt(){                                        // Methode die von Interrupt aufgerufen wird.                                    
  if ( BtnPressed  == false) 
  { 
    BtnPressed=true;
    Tastegedr(); 
  // Serial.println( "BTN");    
   }                                                      // TRUE wird auf FALSE, bzw. LOW auf HIGH geändert und anders herum. 
}
// ---- Rnde ------------------------------------------------------------




//********  Taste abfragen ******************************************************* 
void Tastegedr(){
 // if(digitalRead (Taster_Pin) == LOW){digitalWrite(LED_gruen, LOW);        // wenn Taste gedrückt, grüne LED AUS
    if(BtnPressed==true){ 
  digitalWrite(MOSFET_Pin, HIGH);                 // Entladung einschalten, MOSFET EIN 
  digitalWrite(LED_gruen, LOW);                   // grüneLED AUS 
  digitalWrite(LED_rot, HIGH);                    // rote LED EIN 
  
  // Serial.println( "Taste gedrückt!!");            // serielle Meldung
  fertig=false;                                   // rückstellen, Messung beginnt
  previousMillis = millis();                      // merken, wichtig für die Folgemessung
 // millisPassed=0;
  //sample1=0;                                      // 1. Messwert auf Null
  //sample2=0;                                      // 2. Messwert auf Null
  // Serial.println( "BTN");    
  BtnPressed=false;  
 
  } 
}
// ----- Ende Tastegedr   ---------------------------
 
//*************Buzzer Beep Function *********************************************
  void beep(unsigned char delay_time){
  analogWrite(9, 20);                             // PWM signal to generate beep tone  warum 20?   (Buzzer_Pin, 1)  !!
  delay(delay_time);                              // wait for a delayms ms
  analogWrite(Buzzer_Pin, 0);                     // 0 turns it off
  delay(delay_time);                              // Dauer des Warntones (in ms) wurde übergeben
}  

//**************** OLED Anzeigeroutine  ***** Unterprogramm *******************
void draw(void) {
    u8g.setFont(u8g_font_fub14r);                 // Schriftart setzen
    if ( Bat_Volt < Bat_deep){                    // wenn Akkuspg. keiner als Tiefentladespannung
     Capacity = 0.0;                              // letzten Messwert löschen
    // if (neustart == true){ neustart=false; Serial.println( " Neustart !"); setup() ; }
   
   if (count == 0){                               // 0. Anzeige Szene
    u8g.setPrintPos(0,15);                        // setzte Position
   if (digitalRead (NiMH_Pin) == HIGH){           // April 2025 geändert
     u8g.println("Bitte 1,2 Volt"); 
      u8g.setFont(u8g_font_fub11r); 
    u8g.setPrintPos(28,38);                       // setzte Position
    u8g.println("NiCd-Akku"); 
   }
   else{
     u8g.println("Bitte 3,7 Volt"); 
      u8g.setFont(u8g_font_fub11r); 
    u8g.setPrintPos(28,38);                       // setzte Position
    u8g.println("LiPo-Akku"); 
   }
    
    u8g.setPrintPos(30,60);                       // setzte Position
    u8g.println("einlegen!");                     // Serial.println("Hinweis Akku einl. ");    
   }
   if (count>=1) {                                // bei 1, 2 und 3 anzeigen
                  SpAnz();                        // Serial.println("Anzeige der gespeicherten Historie. ");
                 }    
    }
   else if ( Bat_Volt > Bat_High){                // wenn Akkuspg. größer als höchste Akkuspg.
    u8g.setPrintPos(25,38);                       // setzte Position
    u8g.println("High-V!"); 
   }
   // *************************************************************************
   // ******* Akku ist entladen ***********************************************
   else if(Bat_Volt < Bat_Low )    // wenn Akkuspg. kleiner als Mindest-Akkuspg.
   {                  
   if (AkkuLeer==0){ A_entladen();delay (3000);}         // UP 'A_entladen()' aufrufen
   u8g.drawStr(0, 20, "U: ");                     // setze Position für den String auf X, Y
   // u8g.drawStr(3, 40, "I : ");                 // ...
   u8g.drawStr(0, 60, "C: ");                     // ...
   u8g.setPrintPos(28,20);                        // setzte Position
   u8g.print( Bat_Volt,2);                        // display Battery Voltage in Volt
   u8g.println("V");                              // "V"
   u8g.setPrintPos(6,40);                         // setzte Position
   // u8g.print( mA,0);                           // display Curr_Amp in mA
   u8g.println("-entladen-");                     // "mA"
   u8g.setPrintPos(28, 60);                       // setzte Position
   u8g.print( Capacity ,1);                       // display capacity in mAh
   u8g.println("mAh");                            // "mAh"
    //delay(2000);                                  // (4000) Beim Start schon entladen, also "leer"
  }
    
  
      // ******* Anzeige beim Meßvorgang und vor dem Start der Entladung  ****************************
   else if(Bat_Volt >= Bat_Low && Bat_Volt < Bat_High  ){
    //  Serial.println("Spannungsanzeige bei der Entladung. ");
   u8g.drawStr(0, 20, "U: ");     // setze Position für den String auf X, Y
   u8g.setPrintPos(28,20);        // setzte Position
   u8g.print( Bat_Volt,2);        // display Battery Voltage in Volt
   u8g.println("V");              // "V"
   u8g.setPrintPos(6,40);         // setzte Position
   u8g.drawStr(3, 40, "I : ");    // Formelzeichen für Strom "I" anzeigen
   u8g.setPrintPos(28,40);        // setzte Position
   u8g.print( Curr_mA,0);         // Strom anzeigen in mA ohne Nachkommastelle
   u8g.println(" mA");            // Einheit "mA" anzeigen
   u8g.drawStr(0, 60, "C: ");     // ...
   u8g.setPrintPos(28, 60);       // setzte Position
   u8g.print( Capacity ,1);       // display capacity in mAh
   u8g.println("mAh");            // "mAh"
  }
}



void Messen()
{
// ***************************************************************
// ***********  Akku-Spannung (high Side) messen *****************
  for(int i=0;i< 100;i++)                         // 100 Messungen
  {
   sample1=sample1+analogRead(Bat_Pin);           // lese die Spannung vom Spannungsteiler (High-Side)
   delay (2);                                     // kurze Verzögerung
  }
  sample1=sample1/100;                            // Mittelwert bilden "sample 1" geteilt durch 100
  Bat_Volt =  sample1 * Vcc/1024.0;               // Akkuspannung = Meßwert mal ca. 4,85      

 // *********  Spannung am Widerstand (low Side) messen **********
   for(int i=0;i< 100;i++)                        // 100 Messungen
  {
   sample2=sample2+analogRead(Res_Pin);           // lese die Spannung vom Spannungsteiler (Low-Side)
   delay (2);
  }
  sample2=sample2/100;                            // Mittelwert bilden "sample 2"  geteilt durch 100
  Res_Volt =  sample2 * Vcc/ 1024.0;              // Widerstandsspannung = Meßwert mal 2 
  
// ***********  Akku-Spannung messen  Ende ********************
// ************************************************************

}